    clear all;
    close all;        
 
    if(exist('PathName','var')==0); PathName = ''; end
    
    delimiterIn = '';
    headerLinesIn = 0;   
  
    figure;
    set(gcf, 'Position', [50, 50, 600, 600])
    set(gca,'fontsize',18,'fontname','times');
    hold on;    
    
    n = 9;
    for i = 1:n
   
%Open the datafile
    FilterSpec = '.dat';

    DialogTitle = 'Select file with R/T data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata(posH_Datafile);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
    
%Plot Data        
    plot(Data(:,1),Data(:,2));
    
    
    end
    
    set(gca,'fontsize',18,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it T \rm (K)','fontsize',20,'fontname','times');
    ylabel('\it R \rm (\Omega)','fontsize',20,'fontname','times');
    set(findall(gca, 'Type', 'Line'),'LineWidth',1.25);
    %title('Resistance v Temperature');
    box on;
    xlim([0 10]);    
    %legend('Bulk','100 nm','45 nm','24 nm','16 nm','14','9 nm','Location','NorthWest');
    %legend boxoff;
  
        
 
    
  